/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;

public class bfbasic {
    public static final String VERSION = "1.30";
    static boolean debug = false;
    static boolean insert = false;
    static boolean crlf = false;
    static boolean needpre = true;
    static boolean needpost = false;
    static BufferedReader in;
    static PrintStream out;
    static HashMap var;
    static HashMap label;
    static int varnext;
    static int line;
    static int mp;
    static int linepos;
    static String p;
    static String sourceline;
    static char a;
    static Stack dostack;
    static Stack forstack;
    static Stack ifstack;
    static int annex;
    static int doannex;
    static int ifannex;
    static int forannex;
    static int gosubannex;

    public static void main(String[] stringArray) {
        System.out.println("BFBASIC Basic Compiler, version 1.30.  Copyright 2001 Jeffry Johnston.");
        System.out.println();
        String string = "";
        String string2 = "";
        int n = 0;
        while (true) {
            try {
                if (stringArray[n].equals("-?")) {
                    bfbasic.usage();
                    System.exit(0);
                } else if (stringArray[n].equalsIgnoreCase("-c")) {
                    crlf = true;
                } else if (stringArray[n].equalsIgnoreCase("-d")) {
                    debug = true;
                } else if (stringArray[n].equalsIgnoreCase("-o")) {
                    string2 = stringArray[n + 1];
                    ++n;
                } else {
                    string = stringArray[n];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            ++n;
        }
        if (string.equals("")) {
            bfbasic.usage();
            bfbasic.errout("Error: No input file given");
        }
        if ((n = string.indexOf(46)) == -1) {
            if (string2.equals("")) {
                string2 = string + ".bf";
            }
            string = string + ".bas";
        } else if (string2.equals("")) {
            string2 = string.substring(0, n) + ".bf";
        }
        System.out.println("Input file : " + string);
        System.out.println("Output file: " + string2);
        try {
            in = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            bfbasic.errout("Error opening '" + string + "'.  File not found");
        }
        try {
            out = new PrintStream(new FileOutputStream(string2));
        }
        catch (IOException iOException) {
            bfbasic.errout("Error opening '" + string2 + "' for output");
        }
        out.print("[ BF Code Produced by BFBASIC 1.30");
        if (debug) {
            out.print(" (debug comments)");
        }
        out.println(" ]");
        String string3 = "IGT0123456";
        n = 0;
        while (n < string3.length()) {
            bfbasic.addvar("_" + string3.charAt(n), 1);
            ++n;
        }
        bfbasic.first();
        while (true) {
            sourceline = sourceline.trim();
            while (sourceline.length() > 0 && sourceline.charAt(0) == ':') {
                sourceline = sourceline.substring(1).trim();
            }
            if (sourceline.length() > 0 && sourceline.charAt(0) == '\'') {
                sourceline = "";
            }
            if (sourceline.equals("")) {
                try {
                    ++line;
                    sourceline = in.readLine();
                }
                catch (IOException iOException) {
                    bfbasic.errout("Error reading '" + string + "'");
                }
                if (sourceline == null) break;
                sourceline = sourceline.trim();
            }
            bfbasic.parse();
            if ((p = p.toUpperCase()).equals("")) continue;
            if (p.equals("BEEP")) {
                bfbasic.bf_beep();
                continue;
            }
            if (p.equals("BF")) {
                bfbasic.bf_bf();
                continue;
            }
            if (p.equals("CLS")) {
                bfbasic.bf_cls();
                continue;
            }
            if (p.equals("COLOR")) {
                bfbasic.bf_color();
                continue;
            }
            if (p.equals("DIM")) {
                bfbasic.bf_dim();
                continue;
            }
            if (p.equals("DO")) {
                bfbasic.bf_do();
                continue;
            }
            if (p.equals("ELSE")) {
                bfbasic.bf_else();
                continue;
            }
            if (p.equals("END")) {
                bfbasic.bf_end();
                continue;
            }
            if (p.equals("EXIT")) {
                bfbasic.bf_exit();
                continue;
            }
            if (p.equals("FOR")) {
                bfbasic.bf_for();
                continue;
            }
            if (p.equals("GOSUB")) {
                bfbasic.bf_gosub();
                continue;
            }
            if (p.equals("GOTO")) {
                bfbasic.bf_goto();
                continue;
            }
            if (p.equals("IF")) {
                bfbasic.bf_if();
                continue;
            }
            if (p.equals("INPUT")) {
                bfbasic.bf_input();
                continue;
            }
            if (p.equals("LET")) {
                bfbasic.parse();
                bfbasic.bf_let();
                continue;
            }
            if (p.equals("LOCATE")) {
                bfbasic.bf_locate();
                continue;
            }
            if (p.equals("LOOP")) {
                bfbasic.bf_loop();
                continue;
            }
            if (p.equals("NEXT")) {
                bfbasic.bf_next();
                continue;
            }
            if (p.equals("ONGOTO")) {
                bfbasic.bf_ongoto();
                continue;
            }
            if (p.equals("PRINT")) {
                bfbasic.bf_print();
                continue;
            }
            if (p.equals("RANDOMIZE")) {
                bfbasic.bf_randomize();
                continue;
            }
            if (p.equals("REM")) {
                bfbasic.bf_rem();
                continue;
            }
            if (p.equals("RETURN")) {
                bfbasic.bf_return();
                continue;
            }
            if (p.equals("STOP")) {
                bfbasic.bf_end();
                continue;
            }
            if (p.equals("SWAP")) {
                bfbasic.bf_swap();
                continue;
            }
            if (p.equals("SYSTEM")) {
                bfbasic.bf_end();
                continue;
            }
            if (p.equals("WEND")) {
                bfbasic.bf_loop();
                continue;
            }
            if (p.equals("WHILE")) {
                sourceline = "WHILE " + sourceline;
                bfbasic.bf_do();
                continue;
            }
            if (p.equals("?")) {
                bfbasic.bf_print();
                continue;
            }
            if (a == ':') {
                bfbasic.bf_label();
                continue;
            }
            bfbasic.bf_let();
        }
        bfbasic.last();
        if (debug) {
            bfbasic.write("\n");
        }
        bfbasic.write("@\n");
        System.out.println();
        System.out.println("Done, line " + line + ".");
    }

    public static void addvar(String string, int n) {
        string = string.toUpperCase();
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (!(n2 != 0 || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_' || c == '~')) {
                bfbasic.errout("Illegal variable name '" + string + "'");
            }
            ++n2;
        }
        if (debug) {
            bfbasic.write("\n(DIM " + string + "(" + n + "))\n");
        }
        if (var.containsKey(string)) {
            bfbasic.errout("Variable '" + string + "' already dimensioned");
        }
        var.put(string, new Integer(varnext));
        varnext += n;
    }

    public static void arrows(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '@') {
                int n2 = n + 1;
                while (n2 < string.length()) {
                    if ("+-<>[].,".indexOf(string.charAt(n2)) != -1) {
                        string2 = string.substring(n + 1, n2);
                        break;
                    }
                    if (n2 == string.length() - 1) {
                        string2 = string.substring(n + 1);
                        ++n;
                    }
                    ++n2;
                }
                string2 = string2.toUpperCase();
                n = n2 - 1;
                int n3 = 0;
                if (var.containsKey(string2)) {
                    n3 = (Integer)var.get(string2);
                } else {
                    if (string2.charAt(0) == '~') {
                        bfbasic.addvar(string2, 23);
                    } else {
                        bfbasic.addvar(string2, 1);
                    }
                    n3 = (Integer)var.get(string2);
                }
                if (debug) {
                    bfbasic.write(mp + "");
                }
                if (mp < n3) {
                    bfbasic.write(bfbasic.string(n3 - mp, '>'));
                }
                if (mp > n3) {
                    bfbasic.write(bfbasic.string(mp - n3, '<'));
                }
                mp = n3;
            } else {
                bfbasic.write(c + "");
            }
            ++n;
        }
    }

    public static void bf_beep() {
        String string = bfbasic.pre() + "@_0+++++++.[-]" + bfbasic.post();
        if (debug) {
            string = "\n(BEEP)\n" + string;
        }
        bfbasic.arrows(string);
    }

    public static void bf_bf() {
        sourceline = (a + sourceline).trim();
        int n = sourceline.indexOf(39);
        if (n != -1) {
            sourceline = sourceline.substring(0, n);
        }
        needpost = false;
        String string = bfbasic.pre() + sourceline.trim() + bfbasic.post();
        if (debug) {
            string = "\n(BF)\n" + string;
        }
        bfbasic.arrows(string);
        sourceline = "";
        needpre = false;
    }

    public static void bf_cls() {
        if (debug) {
            bfbasic.write("\n{CLS}\n");
        }
        sourceline = "PRINT \"\u001b[2J\";:" + sourceline;
    }

    public static void bf_color() {
        sourceline = (a + sourceline).trim();
        int n = bfbasic.findexpr("", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string = sourceline.substring(0, n).trim();
        sourceline = "PRINT \"\u001b[\"; " + string + "; \"m\";:" + sourceline.substring(n).trim();
        if (debug) {
            bfbasic.write("\n{COLOR " + bfbasic.debugtext(string) + "}\n");
        }
    }

    public static void bf_dim() {
        bfbasic.parse();
        int n = 0;
        if (a == '(') {
            String string = p;
            bfbasic.parse();
            if (a != ')') {
                bfbasic.errout("Mismatched parenthesis");
            }
            try {
                n = Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {
                bfbasic.errout("Invalid number '" + p + "'");
            }
            if (n < 0 || n > 255) {
                bfbasic.errout("Array size '" + n + "' out of range (0 - 255)");
            }
            bfbasic.addvar(string, n * 2 + 5);
        } else {
            bfbasic.addvar(p, 1);
        }
    }

    public static void bf_do() {
        String string = "_D" + doannex;
        if (bfbasic.parseif()) {
            if (debug) {
                bfbasic.write("\n{DO}\n");
            }
            dostack.push(new Integer(doannex));
        } else {
            bfbasic.parse();
            p = p.toUpperCase();
            if (p.equals("WHILE")) {
                sourceline = (a + sourceline).trim();
                int n = bfbasic.findexpr("", 0);
                if (n == -1) {
                    bfbasic.errout("Syntax error");
                }
                String string2 = sourceline.substring(0, n).trim();
                if (debug) {
                    bfbasic.write("\n{DO WHILE " + bfbasic.debugtext(string2) + "}\n");
                }
                dostack.push(new Integer(-doannex));
                sourceline = "IF NOT(" + string2 + ") THEN GOTO _D" + (doannex + 1) + ":" + sourceline.substring(n).trim();
            } else if (p.equals("UNTIL")) {
                sourceline = (a + sourceline).trim();
                int n = bfbasic.findexpr("", 0);
                if (n == -1) {
                    bfbasic.errout("Syntax error");
                }
                String string3 = sourceline.substring(0, n).trim();
                if (debug) {
                    bfbasic.write("\n{DO UNTIL " + bfbasic.debugtext(string3) + "}\n");
                }
                dostack.push(new Integer(-doannex));
                sourceline = "IF " + string3 + " THEN GOTO _D" + (doannex + 1) + ":" + sourceline.substring(n).trim();
            } else {
                bfbasic.errout("Syntax error");
            }
        }
        p = string;
        bfbasic.bf_label();
        doannex += 2;
    }

    public static void bf_else() {
        if (debug) {
            bfbasic.write("\n{ELSE}\n");
        }
        if (ifstack.empty()) {
            bfbasic.errout("ELSE without IF");
        }
        Integer n = (Integer)ifstack.pop();
        sourceline = "GOTO _I" + ifannex + ":_I" + n + ":" + sourceline;
        ifstack.push(new Integer(ifannex++));
    }

    public static void bf_end() {
        bfbasic.parse();
        if (p.equalsIgnoreCase("IF")) {
            if (debug) {
                bfbasic.write("\n{END IF}\n");
            }
            if (ifstack.empty()) {
                bfbasic.errout("END IF without IF");
            }
            Integer n = (Integer)ifstack.pop();
            sourceline = "_I" + n + ":" + sourceline;
        } else {
            needpost = true;
            sourceline = (p + a + sourceline).trim();
            String string = bfbasic.pre() + "@_I[-]@_G[-]" + bfbasic.post();
            if (debug) {
                string = "\n(END)\n" + string;
            }
            bfbasic.arrows(string);
            needpre = true;
        }
    }

    public static void bf_exit() {
        bfbasic.parse();
        p = p.toUpperCase();
        if (p.equals("DO")) {
            if (debug) {
                bfbasic.write("\n{EXIT DO}\n");
            }
            if (dostack.empty()) {
                bfbasic.errout("EXIT DO without DO");
            }
            Integer n = (Integer)dostack.pop();
            sourceline = "GOTO _D" + (Math.abs(n) + 1) + ":" + sourceline;
            if (n > 0) {
                n = new Integer(-n.intValue());
            }
            dostack.push(n);
        } else if (p.equals("FOR")) {
            if (debug) {
                bfbasic.write("\n{EXIT FOR}\n");
            }
            if (forstack.empty()) {
                bfbasic.errout("EXIT FOR without FOR");
            }
            Integer n = (Integer)forstack.pop();
            sourceline = "GOTO _F" + (Math.abs(n) + 1) + ":" + sourceline;
            if (n > 0) {
                n = new Integer(-n.intValue());
            }
            forstack.push(n);
        } else {
            bfbasic.errout("Syntax error");
        }
    }

    public static void bf_for() {
        String string = "_F" + forannex;
        int n = bfbasic.findexpr("=", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string2 = sourceline.substring(0, n).trim();
        sourceline = sourceline.substring(n + 1).trim();
        n = bfbasic.findexpr("TO", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string3 = sourceline.substring(0, n).trim();
        sourceline = sourceline.substring(n + 2).trim();
        n = bfbasic.findexpr("", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string4 = sourceline.substring(0, n).trim();
        forstack.push(new Integer(-forannex));
        sourceline = string2 + "=" + string3 + ":" + string + ":IF " + string2 + ">" + string4 + " THEN GOTO _F" + (forannex + 1) + ":" + sourceline.substring(n).trim();
        if (debug) {
            bfbasic.write("\n{FOR " + bfbasic.debugtext(string2) + "=" + bfbasic.debugtext(string3) + " TO " + bfbasic.debugtext(string4) + "}\n");
        }
        forannex += 2;
    }

    public static void bf_gosub() {
        p = "_G" + gosubannex++;
        bfbasic.labelval("", "");
        String string = p;
        bfbasic.parse();
        int n = (Integer)label.get(string);
        sourceline = "_GS(_GP)=" + n + ":_GP=_GP+1:GOTO " + p + ":" + ":" + string + ":" + sourceline;
        if (debug) {
            bfbasic.write("\n{GOSUB " + p + "}\n");
        }
    }

    public static void bf_goto() {
        needpost = true;
        bfbasic.parse();
        String string = bfbasic.pre() + bfbasic.labelval("@_G", "@_I") + bfbasic.post();
        if (debug) {
            string = "\n(GOTO " + p + ")\n" + string;
        }
        bfbasic.arrows(string);
        needpre = true;
    }

    public static void bf_if() {
        Object object;
        sourceline = (a + sourceline).trim();
        int n = bfbasic.findexpr("THEN", 0);
        if (n == -1) {
            bfbasic.errout("IF without THEN");
        }
        String string = sourceline.substring(0, n).trim();
        sourceline = sourceline.substring(n).trim();
        bfbasic.parse();
        bfbasic.parse();
        p = p.toUpperCase();
        String string2 = "";
        if (p.equals("GOTO")) {
            bfbasic.parse();
            if (debug) {
                string2 = "\n(IF " + bfbasic.debugtext(string) + " THEN GOTO " + p + ")\n";
            }
        } else if (p.equals("EXIT")) {
            bfbasic.parse();
            p = p.toUpperCase();
            if (p.equals("DO")) {
                if (dostack.empty()) {
                    bfbasic.errout("EXIT DO without DO");
                }
                object = (Integer)dostack.pop();
                p = "_D" + (Math.abs((Integer)object) + 1);
                if ((Integer)object > 0) {
                    object = new Integer(-((Integer)object).intValue());
                }
                dostack.push(object);
                if (debug) {
                    string2 = "\n(IF " + bfbasic.debugtext(string) + " THEN {EXIT DO}(GOTO _D" + (Math.abs((Integer)object) + 1) + "))\n";
                }
            } else if (p.equals("FOR")) {
                if (forstack.empty()) {
                    bfbasic.errout("EXIT FOR without FOR");
                }
                object = (Integer)forstack.pop();
                p = "_F" + (Math.abs((Integer)object) + 1);
                if ((Integer)object > 0) {
                    object = new Integer(-((Integer)object).intValue());
                }
                forstack.push(object);
                if (debug) {
                    string2 = "\n(IF " + bfbasic.debugtext(string) + " THEN {EXIT FOR}(GOTO _F" + (Math.abs((Integer)object) + 1) + "))\n";
                }
            } else {
                bfbasic.errout("Syntax error");
            }
        } else {
            if (debug) {
                bfbasic.write("\n{IF " + bfbasic.debugtext(string) + " THEN}\n");
            }
            sourceline = "IF NOT(" + string + ") THEN GOTO _I" + ifannex + ":" + sourceline;
            ifstack.push(new Integer(ifannex++));
            return;
        }
        needpost = true;
        object = new AlgebraicExpression(string);
        string2 = string2 + bfbasic.pre() + ((AlgebraicExpression)object).parse() + "@_T0[" + bfbasic.labelval("@_G", "@_I") + "@_T0[-]]" + bfbasic.post();
        bfbasic.arrows(string2);
        needpre = true;
    }

    public static void bf_input() {
        bfbasic.parse();
        String string = "";
        if (a == '(') {
            String string2;
            int n = bfbasic.findexpr("", 1);
            if (n == -1) {
                bfbasic.errout("Syntax error");
            }
            if ((string2 = sourceline.substring(0, n).trim()).length() < 1 || string2.charAt(string2.length() - 1) != ')') {
                bfbasic.errout("Mismatched parenthesis");
            }
            string2 = string2.substring(0, string2.length() - 1).trim();
            sourceline = sourceline.substring(n).trim();
            AlgebraicExpression algebraicExpression = new AlgebraicExpression(string2);
            string = bfbasic.pre() + algebraicExpression.parse() + "@~" + p + ">>[-]<<@_T0[@~" + p + ">>+<<@_T0-]" + "@_0+[-@_1,.----------" + (crlf ? "---" : "") + "[@_0+" + "@_2+++++" + (crlf ? "" : "+") + "[@_1------" + (crlf ? "-" : "") + "@_2-]" + "@_T0[@_2+@_T0-]@_2[@_T0++++++++++@_2-]@_1[@_T0+@_1-]]@_0]" + (crlf ? "++++++++++.[-]" : "") + "@~" + p + ">[-]<@_T0[@~" + p + ">+<@_T0-]@~" + p + ">>[>>[-]<<-[>>+<<-]+>>]>[-]<<<[<<]>[>[>>]>+<<<[<<]>-]>-<<" + bfbasic.post();
            if (debug) {
                string = "\n(INPUT " + p + "(" + bfbasic.debugtext(string2) + ")\n" + string;
            }
        } else {
            if (debug) {
                string = "\n(INPUT " + p + ")\n";
            }
            string = string + bfbasic.pre() + "@" + p + "[-]@_0+[-@_1,.----------" + (crlf ? "---" : "") + "[@_0+" + "@_2+++++" + (crlf ? "" : "+") + "[@_1------" + (crlf ? "-" : "") + "@_2-]" + "@" + p + "[@_2+@" + p + "-]@_2[@" + p + "++++++++++@_2-]" + "@_1[@" + p + "+@_1-]]@_0]" + (crlf ? "++++++++++.[-]" : "") + bfbasic.post();
        }
        bfbasic.arrows(string);
    }

    public static void bf_label() {
        String string = "";
        if (debug) {
            string = "\n(LABEL " + p + ")\n";
            if (!needpre) {
                needpost = true;
                string = string + "\t" + bfbasic.post();
            }
            string = string + "\n    (code) \t";
        } else if (!needpre) {
            needpost = true;
            string = string + bfbasic.post();
        }
        string = string + bfbasic.labelval("@_1", "@_2") + "@_1[-]@_0[-]@_G[@_1+@_0+@_G-]@_0[@_G+@_0-]" + "@_T[-]+@_1[@_T-@_1-]@_T[" + "@_1+@_0[-]@_I[@_0+@_2-@_I-]@_0[@_I+@_0-]" + "@_2[@_1-@_2[-]]@_1[@_G[-]+@_1[-]]" + "@_T-]@_2[-]";
        if (debug) {
            string = string + "\t";
        }
        bfbasic.arrows(string);
        p = "";
        needpre = true;
    }

    public static void bf_let() {
        if (a == '(') {
            bfbasic.bf_letarray();
        } else if (a == '=') {
            bfbasic.bf_letvar();
        } else {
            bfbasic.errout("Syntax error");
        }
    }

    public static void bf_letarray() {
        String string;
        int n = bfbasic.findexpr("=", 1);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        if ((string = sourceline.substring(0, n).trim()).length() < 1 || string.charAt(string.length() - 1) != ')') {
            bfbasic.errout("Mismatched parenthesis");
        }
        string = string.substring(0, string.length() - 1).trim();
        sourceline = sourceline.substring(n).trim();
        String string2 = p;
        bfbasic.parse();
        AlgebraicExpression algebraicExpression = new AlgebraicExpression(string);
        String string3 = bfbasic.pre() + algebraicExpression.parse() + "@~" + string2 + ">>[-]<<@_T0[@~" + string2 + ">>+<<@_T0-]";
        n = bfbasic.findexpr("", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string4 = sourceline.substring(0, n).trim();
        sourceline = sourceline.substring(n).trim();
        algebraicExpression = new AlgebraicExpression(string4);
        string3 = string3 + algebraicExpression.parse() + "@~" + string2 + ">[-]<@_T0[@~" + string2 + ">+<@_T0-]@~" + string2 + ">>[>>[-]<<-[>>+<<-]+>>]>[-]<<<[<<]>[>[>>]>+<<<[<<]>-]>-<<" + bfbasic.post();
        if (debug) {
            string3 = "\n(" + string2 + "(" + bfbasic.debugtext(string) + ")=" + bfbasic.debugtext(string4) + ")\n" + string3;
        }
        bfbasic.arrows(string3);
    }

    public static void bf_letvar() {
        int n = bfbasic.findexpr("", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string = sourceline.substring(0, n).trim();
        sourceline = sourceline.substring(n).trim();
        AlgebraicExpression algebraicExpression = new AlgebraicExpression(string);
        String string2 = bfbasic.pre() + algebraicExpression.parse() + "@" + p + "[-]@_T0[@" + p + "+@_T0-]" + bfbasic.post();
        if (debug) {
            string2 = "\n(" + p + "=" + bfbasic.debugtext(string) + ")\n" + string2;
        }
        bfbasic.arrows(string2);
    }

    public static void bf_locate() {
        sourceline = (a + sourceline).trim();
        int n = bfbasic.findexpr(",", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string = sourceline.substring(0, n).trim();
        sourceline = sourceline.substring(n).trim();
        bfbasic.parse();
        n = bfbasic.findexpr("", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string2 = sourceline.substring(0, n).trim();
        sourceline = "PRINT \"\u001b[\"; " + string + "; \";\"; " + string2 + "; \"H\";:" + sourceline.substring(n).trim();
        if (debug) {
            bfbasic.write("\n{LOCATE " + bfbasic.debugtext(string + "," + string2) + "}\n");
        }
    }

    public static void bf_loop() {
        if (dostack.empty()) {
            bfbasic.errout("LOOP without DO");
        }
        if (bfbasic.parseif()) {
            if (debug) {
                bfbasic.write("\n{LOOP}\n");
            }
            Integer n = (Integer)dostack.pop();
            String string = "GOTO _D" + Math.abs(n) + ":";
            if (n < 0) {
                string = string + "_D" + (-n.intValue() + 1) + ":";
            }
            sourceline = string + sourceline;
        } else {
            bfbasic.parse();
            p = p.toUpperCase();
            if (p.equals("WHILE")) {
                sourceline = (a + sourceline).trim();
                int n = bfbasic.findexpr("", 0);
                if (n == -1) {
                    bfbasic.errout("Syntax error");
                }
                String string = sourceline.substring(0, n).trim();
                sourceline = sourceline.substring(n).trim();
                if (debug) {
                    bfbasic.write("\n{LOOP WHILE " + bfbasic.debugtext(string) + "}\n");
                }
                Integer n2 = (Integer)dostack.pop();
                String string2 = "IF " + string + " THEN GOTO _D" + Math.abs(n2) + ":";
                if (n2 < 0) {
                    string2 = string2 + "_D" + (-n2.intValue() + 1) + ":";
                }
                sourceline = string2 + sourceline;
            } else if (p.equals("UNTIL")) {
                sourceline = (a + sourceline).trim();
                int n = bfbasic.findexpr("", 0);
                if (n == -1) {
                    bfbasic.errout("Syntax error");
                }
                String string = sourceline.substring(0, n).trim();
                sourceline = sourceline.substring(n).trim();
                if (debug) {
                    bfbasic.write("\n{LOOP UNTIL " + bfbasic.debugtext(string) + "}\n");
                }
                Integer n3 = (Integer)dostack.pop();
                String string3 = "IF NOT(" + string + ") THEN GOTO _D" + Math.abs(n3) + ":";
                if (n3 < 0) {
                    string3 = string3 + "_D" + (-n3.intValue() + 1) + ":";
                }
                sourceline = string3 + sourceline;
            } else {
                bfbasic.errout("Syntax error");
            }
        }
    }

    public static void bf_next() {
        int n = bfbasic.findexpr("", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string = sourceline.substring(0, n).trim();
        Integer n2 = (Integer)forstack.pop();
        String string2 = string + "=" + string + "+1:GOTO _F" + Math.abs(n2) + ":";
        if (n2 < 0) {
            string2 = string2 + "_F" + (-n2.intValue() + 1) + ":";
        }
        sourceline = string2 + sourceline.substring(n).trim();
        if (debug) {
            bfbasic.write("\n{NEXT " + bfbasic.debugtext(string) + "}\n");
        }
    }

    public static void bf_ongoto() {
        needpost = true;
        sourceline = (a + sourceline).trim();
        int n = bfbasic.findexpr("", 0);
        if (n == -1) {
            bfbasic.errout("Syntax error");
        }
        String string = sourceline.substring(0, n).trim();
        sourceline = sourceline.substring(n).trim();
        AlgebraicExpression algebraicExpression = new AlgebraicExpression(string);
        String string2 = bfbasic.pre() + algebraicExpression.parse() + "@_I[-]@_G[-]@_T0[@_I+@_T0-]" + bfbasic.post();
        if (debug) {
            string2 = "\n(ONGOTO " + bfbasic.debugtext(string) + ")\n" + string2;
        }
        bfbasic.arrows(string2);
        needpre = true;
    }

    public static void bf_print() {
        if (bfbasic.parseif()) {
            String string = bfbasic.pre() + bfbasic.newline() + bfbasic.post();
            if (debug) {
                string = "\n(PRINT)\n" + string;
            }
            bfbasic.arrows(string);
        } else {
            String string = "";
            while (!bfbasic.parseif()) {
                Object object;
                String string2;
                int n;
                boolean bl = false;
                if (sourceline.length() > 0 && sourceline.charAt(0) == '\"') {
                    bfbasic.parse();
                    p = p.substring(1);
                    n = p.indexOf(34);
                    if (n == -1) {
                        bfbasic.errout("Mismatched quotation mark");
                    }
                    if (a == ';') {
                        bl = true;
                        a = (char)32;
                    }
                    if ((p = p.substring(0, n)).length() == 0) {
                        if (!bl) {
                            if (debug) {
                                string = string + "\n(PRINT \"\")\n";
                            }
                            string = string + bfbasic.newline();
                        }
                    } else {
                        if (debug) {
                            string = string + "\n(PRINT \"" + bfbasic.debugtext(p) + "\"";
                            if (bl) {
                                string = string + ";";
                            }
                            string = string + ")\n";
                        }
                        string = string + "@_0" + bfbasic.bf_text(p);
                        if (!bl) {
                            string = string + bfbasic.newline();
                        }
                    }
                } else if (sourceline.length() >= 1 && sourceline.charAt(0) == ';') {
                    sourceline = sourceline.substring(1);
                } else if (sourceline.length() >= 4 && sourceline.substring(0, 4).equalsIgnoreCase("CHR$")) {
                    bfbasic.parse();
                    if (a != '(') {
                        bfbasic.errout("Syntax error");
                    }
                    if ((n = bfbasic.findexpr("", 1)) == -1) {
                        bfbasic.errout("Syntax error");
                    }
                    if ((string2 = sourceline.substring(0, n).trim()).length() < 1 || string2.charAt(string2.length() - 1) != ')') {
                        bfbasic.errout("Mismatched parenthesis");
                    }
                    string2 = string2.substring(0, string2.length() - 1).trim();
                    if ((sourceline = sourceline.substring(n).trim()).length() > 0 && sourceline.charAt(0) == ';') {
                        bl = true;
                        sourceline = sourceline.substring(1);
                    }
                    object = new AlgebraicExpression(string2);
                    if (debug) {
                        string = string + "\n(PRINT CHR$(" + bfbasic.debugtext(string2) + ")";
                        if (bl) {
                            string = string + ";";
                        }
                        string = string + ")\n";
                    }
                    string = string + ((AlgebraicExpression)object).parse() + "@_T0.";
                    if (!bl) {
                        string = string + bfbasic.newline();
                    }
                } else if (sourceline.length() >= 6 && sourceline.substring(0, 6).equalsIgnoreCase("SPACE$")) {
                    bfbasic.parse();
                    if (a != '(') {
                        bfbasic.errout("Syntax error");
                    }
                    if ((n = bfbasic.findexpr("", 1)) == -1) {
                        bfbasic.errout("Syntax error");
                    }
                    if ((string2 = sourceline.substring(0, n).trim()).length() < 1 || string2.charAt(string2.length() - 1) != ')') {
                        bfbasic.errout("Mismatched parenthesis");
                    }
                    string2 = string2.substring(0, string2.length() - 1).trim();
                    if ((sourceline = sourceline.substring(n).trim()).length() > 0 && sourceline.charAt(0) == ';') {
                        bl = true;
                        sourceline = sourceline.substring(1);
                    }
                    object = new AlgebraicExpression(string2);
                    if (debug) {
                        string = string + "\n(PRINT SPACE$(" + bfbasic.debugtext(string2) + ")";
                        if (bl) {
                            string = string + ";";
                        }
                        string = string + ")\n";
                    }
                    string = string + ((AlgebraicExpression)object).parse() + "@_1++++[@_0++++++++@_1-]@_T0[@_0.@_T0-]@_0[-]";
                    if (!bl) {
                        string = string + bfbasic.newline();
                    }
                } else if (sourceline.length() >= 7 && sourceline.substring(0, 7).equalsIgnoreCase("STRING$")) {
                    bfbasic.parse();
                    if (a != '(') {
                        bfbasic.errout("Syntax error");
                    }
                    if ((n = bfbasic.findexpr(",", 0)) == -1) {
                        bfbasic.errout("Syntax error");
                    }
                    string2 = sourceline.substring(0, n).trim();
                    sourceline = sourceline.substring(n + 1).trim();
                    n = bfbasic.findexpr("", 1);
                    if (n == -1) {
                        bfbasic.errout("Syntax error");
                    }
                    if (((String)(object = sourceline.substring(0, n).trim())).length() < 1 || ((String)object).charAt(((String)object).length() - 1) != ')') {
                        bfbasic.errout("Mismatched parenthesis");
                    }
                    object = ((String)object).substring(0, ((String)object).length() - 1).trim();
                    if ((sourceline = sourceline.substring(n).trim()).length() > 0 && sourceline.charAt(0) == ';') {
                        bl = true;
                        sourceline = sourceline.substring(1);
                    }
                    if (debug) {
                        string = string + "\n(PRINT STRING$(" + bfbasic.debugtext(string2 + "," + (String)object) + ")";
                        if (bl) {
                            string = string + ";";
                        }
                        string = string + ")\n";
                    }
                    AlgebraicExpression algebraicExpression = new AlgebraicExpression(string2);
                    string = string + algebraicExpression.parse() + "@_T0[@_ST+@_T0-]";
                    algebraicExpression = new AlgebraicExpression((String)object);
                    string = string + algebraicExpression.parse() + "@_ST[@_T0.@_ST-]";
                    if (!bl) {
                        string = string + bfbasic.newline();
                    }
                } else {
                    sourceline = (a + sourceline).trim();
                    n = bfbasic.findexpr("", 0);
                    if (n == -1) {
                        bfbasic.errout("Syntax error");
                    }
                    string2 = sourceline.substring(0, n).trim();
                    if ((sourceline = sourceline.substring(n).trim()).length() > 0 && sourceline.charAt(0) == ';') {
                        bl = true;
                        sourceline = sourceline.substring(1);
                    }
                    object = new AlgebraicExpression(string2);
                    if (debug) {
                        string = string + "\n(PRINT " + bfbasic.debugtext(string2);
                        if (bl) {
                            string = string + ";";
                        }
                        string = string + ")\n";
                    }
                    string = string + ((AlgebraicExpression)object).parse() + bfbasic.itoa();
                    if (!bl) {
                        string = string + bfbasic.newline();
                    }
                }
                sourceline = sourceline.trim();
            }
            if (!string.equals("")) {
                string = bfbasic.pre() + string;
                if (debug) {
                    string = "\n{PRINT}\n" + string;
                }
                string = string + bfbasic.post();
                bfbasic.arrows(string);
            }
        }
    }

    public static void bf_randomize() {
        bfbasic.parse();
        if (p.equalsIgnoreCase("KEY")) {
            String string = bfbasic.pre() + "@_0" + bfbasic.bf_text("Random seed?") + "+[@_0-@_1,----------" + (crlf ? "---" : "") + "[@_0+@_1[@_RH+@_1-]" + "@_RH[@_RL+@_1+@_RH-]@_1[@_RH+@_1-]]@_0]" + bfbasic.post();
            if (debug) {
                string = "\n(RANDOMIZE KEY)\n" + string;
            }
            bfbasic.arrows(string);
        } else {
            bfbasic.errout("Syntax error");
        }
    }

    public static void bf_rem() {
        sourceline = "";
    }

    public static void bf_return() {
        sourceline = "_GP=_GP-1:ONGOTO _GS(_GP):" + sourceline;
        if (debug) {
            bfbasic.write("\n{RETURN}\n");
        }
    }

    public static void bf_swap() {
        bfbasic.parse();
        String string = p;
        if (a != ',') {
            bfbasic.errout("Syntax error");
        }
        bfbasic.parse();
        String string2 = bfbasic.pre() + "@" + string + "[@_0+@" + string + "-]@" + p + "[@" + string + "+@" + p + "-]@_0[@" + p + "+@_0-]" + bfbasic.post();
        if (debug) {
            string2 = "\n(SWAP " + string + ", " + p + ")\n" + string2;
        }
        bfbasic.arrows(string2);
    }

    public static String bf_text(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        char[] cArray = new char[7];
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        int[] nArray3 = new int[]{15, 27, 43, 65, 78, 94, 110};
        int[] nArray4 = new int[]{26, 42, 64, 77, 93, 109, 126};
        int n7 = 0;
        String string2 = "";
        boolean[] blArray = new boolean[7];
        int n8 = 0;
        while (n8 < string.length()) {
            n6 = string.charAt(n8);
            if (n6 < 15 || n6 > 126) {
                bfbasic.errout("Invalid ascii character: " + n6);
            }
            n5 = 0;
            while (n5 <= 6) {
                if (!blArray[n5] && n6 >= nArray3[n5] && n6 <= nArray4[n5]) {
                    blArray[n5] = true;
                    cArray[n7] = n6;
                    ++n7;
                }
                ++n5;
            }
            ++n8;
        }
        --n7;
        n6 = 1000;
        n5 = 0;
        int n9 = 1;
        while (n9 <= 50) {
            int n10 = n9;
            n4 = 0;
            n3 = 0;
            while (n3 <= n7) {
                nArray[n3] = Math.round((float)cArray[n3] / (float)n9);
                n10 += nArray[n3];
                n4 += Math.abs(cArray[n3] - n9 * nArray[n3]);
                ++n3;
            }
            if ((n4 += n10) < n6) {
                n6 = n4;
                n5 = n9;
                n2 = 0;
                while (n2 <= 6) {
                    nArray2[n2] = nArray[n2];
                    ++n2;
                }
            }
            ++n9;
        }
        string2 = string2 + bfbasic.string(n5, '+') + "[";
        n3 = 0;
        while (n3 <= n7) {
            string2 = string2 + ">" + bfbasic.string(nArray2[n3], '+');
            int n11 = n3++;
            nArray2[n11] = nArray2[n11] * n5;
        }
        n2 = 0;
        string2 = string2 + bfbasic.string(n7 + 1, '<') + "-]>";
        int n12 = 0;
        while (n12 < string.length()) {
            n = string.charAt(n12);
            int n13 = 0;
            n6 = 255;
            int n14 = 0;
            while (n14 <= n7 + 1) {
                n4 = Math.abs(nArray2[n14] - n);
                if (n4 < n6 || n4 <= n6 && n14 == n2) {
                    n13 = n14;
                    n6 = n4;
                }
                ++n14;
            }
            if (n13 < n2) {
                string2 = string2 + bfbasic.string(n2 - n13, '<');
            }
            if (n13 > n2) {
                string2 = string2 + bfbasic.string(n13 - n2, '>');
            }
            if (n < nArray2[n2 = n13]) {
                string2 = string2 + bfbasic.string(nArray2[n2] - n, '-');
            }
            if (n > nArray2[n2]) {
                string2 = string2 + bfbasic.string(n - nArray2[n2], '+');
            }
            nArray2[n2] = n;
            string2 = string2 + ".";
            ++n12;
        }
        string2 = string2 + bfbasic.string(n7 - n2, '>');
        n = 0;
        while (n <= n7) {
            string2 = string2 + "[-]<";
            ++n;
        }
        return string2;
    }

    public static String debugtext(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '+': {
                    string2 = string2 + "(plus)";
                    break;
                }
                case '-': {
                    string2 = string2 + "(minus)";
                    break;
                }
                case ',': {
                    string2 = string2 + "(comma)";
                    break;
                }
                case '.': {
                    string2 = string2 + "(dot)";
                    break;
                }
                case '<': {
                    string2 = string2 + "(lt)";
                    break;
                }
                case '>': {
                    string2 = string2 + "(gt)";
                    break;
                }
                case '[': {
                    string2 = string2 + "(lsb)";
                    break;
                }
                case ']': {
                    string2 = string2 + "(rsb)";
                    break;
                }
                case '@': {
                    string2 = string2 + "(at)";
                    break;
                }
                case '\u001b': {
                    string2 = string2 + "(esc)";
                    break;
                }
                default: {
                    string2 = string2 + string.substring(n, n + 1);
                }
            }
            ++n;
        }
        return string2;
    }

    public static void errout(String string) {
        System.out.println();
        System.out.print(string);
        if (line > 0) {
            System.out.print(", line " + line);
        }
        System.out.println(".");
        System.exit(1);
    }

    public static int findexpr(String string, int n) {
        string = string.toUpperCase();
        boolean bl = false;
        int n2 = -1;
        int n3 = n;
        int n4 = 0;
        while (n4 < sourceline.length()) {
            char c = sourceline.charAt(n4);
            if (c == '\"') {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                if (c == '(') {
                    ++n3;
                } else if (c == ')' && --n3 < 0) {
                    bfbasic.errout("Mismatched parenthesis");
                }
                if (n3 == 0) {
                    if (string.equals("")) {
                        if (c == ':' || c == '\'' || c == ';') {
                            n2 = n4;
                            break;
                        }
                    } else if (n4 == sourceline.toUpperCase().indexOf(string, n4)) {
                        n2 = n4;
                        break;
                    }
                }
            }
            ++n4;
        }
        if (n2 == -1 && string.equals("")) {
            n2 = sourceline.length();
        }
        return n2;
    }

    public static void first() {
        String string = "@_G+@_I+[";
        if (debug) {
            string = "\n(FIRST)\n    (code) " + string;
        }
        bfbasic.arrows(string);
        needpre = true;
    }

    public static String h(String string, String string2) {
        int n = 0;
        try {
            n = Integer.parseInt(p);
        }
        catch (NumberFormatException numberFormatException) {
            bfbasic.errout("Invalid number or label '" + p + "'");
        }
        if (n < 0 || n > 255) {
            bfbasic.errout("Number '" + n + "' out of range (0 - 255)");
        }
        int n2 = (n & 0xF0) >> 4;
        int n3 = n & 0xF;
        String string3 = "";
        if (n2 == 0) {
            string3 = string3 + string + "[-]";
            string3 = string3 + string2 + "[-]" + bfbasic.string(n3, '+');
        } else {
            string3 = string3 + string2 + "[-]" + bfbasic.string(n3, '+');
            string3 = string3 + string + "[-]" + bfbasic.string(n2, '+');
            string3 = string3 + "[" + string2 + "++++++++++++++++" + string + "-]";
        }
        return string3;
    }

    public static boolean isnum() {
        boolean bl = false;
        if (p.length() >= 2 && p.substring(0, 2).equalsIgnoreCase("&H") || p.length() > 0 && p.charAt(0) >= '0' && p.charAt(0) <= '9') {
            bl = true;
        }
        return bl;
    }

    public static String itoa() {
        String string = "@_1[-]@_2[-]@_3[-]@_4[-]@_T0[@_3+[@_4+@_0+@_3-]@_0[@_3+@_0-]+@_4----------[@_0-@_4[-]]@_0[@_2+@_3[-]@_0-]@_2[@_4+@_0+@_2-]@_0[@_2+@_0-]+@_4----------[@_0-@_4[-]]@_0[@_1+@_2[-]@_0-]@_T0-]@_1[@_0++++++++[@_1++++++@_2++++++@_0-]@_1.@_2.[-]@_1[-]]@_2[@_0++++++++[@_2++++++@_0-]@_2.[-]]@_0++++++++[@_3++++++@_0-]@_3.[-]";
        return string;
    }

    public static String labelval(String string, String string2) {
        int n;
        p = p.toUpperCase().trim();
        int n2 = 0;
        while (n2 < p.length()) {
            n = p.charAt(n2);
            if (!(n == 95 || n >= 65 && n <= 90 || n >= 48 && n <= 57)) {
                bfbasic.errout("Label '" + p + "' contains the invalid character '" + (char)n + "'");
            }
            if (n >= 48 && n <= 57 && n2 == 0) {
                bfbasic.errout("Label cannot begin with a number");
            }
            ++n2;
        }
        n = 0;
        if (label.containsKey(p)) {
            n = (Integer)label.get(p);
        } else {
            label.put(p, new Integer(annex));
            n = annex++;
            if (annex > 256) {
                bfbasic.errout("Out of line numbers");
            }
        }
        int n3 = (n & 0xF0) >> 4;
        int n4 = n & 0xF;
        String string3 = "";
        if (n3 == 0) {
            string3 = string3 + string + "[-]";
            string3 = string3 + string2 + "[-]" + bfbasic.string(n4, '+');
        } else {
            string3 = string3 + string2 + "[-]" + bfbasic.string(n4, '+');
            string3 = string3 + string + "[-]" + bfbasic.string(n3, '+');
            string3 = string3 + "[" + string2 + "++++++++++++++++" + string + "-]";
        }
        return string3;
    }

    public static void last() {
        needpost = true;
        String string = bfbasic.pre() + "@_I[-]@_G[-]" + bfbasic.post();
        if (debug) {
            string = "\n(END)\n" + string;
        }
        if (debug) {
            string = string + "\n(LAST)\n    (code) ";
        }
        string = string + "@_I]";
        bfbasic.arrows(string);
    }

    public static String newline() {
        return "@_0++++++++++" + (crlf ? "+++" : "") + "." + (crlf ? "---." : "") + "[-]";
    }

    public static void parse() {
        sourceline = sourceline.trim();
        boolean bl = false;
        p = "";
        int n = 0;
        while (n < sourceline.length()) {
            a = sourceline.charAt(n);
            if (a == '\"') {
                bl = !bl;
            } else if (": '()=+-<>*/,.[];".indexOf(a) != -1 && !bl) break;
            ++n;
        }
        p = sourceline.substring(0, n).trim();
        if (n == sourceline.length() || a == '\'') {
            sourceline = "";
            a = (char)58;
        } else if (n < sourceline.length()) {
            sourceline = sourceline.substring(n).trim();
        }
        if (sourceline.length() > 0 && "=()<+-*/,;".indexOf(sourceline.charAt(0)) != -1) {
            a = sourceline.charAt(0);
            sourceline = sourceline.substring(1).trim();
        }
    }

    public static boolean parseif() {
        boolean bl = true;
        if (sourceline.length() > 0 && sourceline.charAt(0) != '\'' && sourceline.charAt(0) != ':') {
            bl = false;
        }
        return bl;
    }

    public static String pre() {
        String string = "";
        if (needpre) {
            string = "@_0[-]@_T[-]@_G[@_T+@_0+@_G-]@_0[@_G+@_0-]@_T[";
            if (debug) {
                string = "    (pre)  \t" + string + "\t\n    (code) \t";
            }
            needpre = false;
        } else if (debug) {
            string = "    (code) \t";
        }
        return string;
    }

    public static String post() {
        String string = "";
        if (needpost) {
            if (debug) {
                string = "\t\n    (post) ";
            }
            string = string + "@_T[-]]";
            needpost = false;
        } else if (debug) {
            string = "\t\n";
        }
        return string;
    }

    public static String string(int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static void usage() {
        System.out.println("Usage: bfbasic [-c] [-d] [-o outfile] file[.bas] [-?]");
        System.out.println("Where: file         Input filename");
        System.out.println("       -c           Treat newlines as CRLF, default: LF");
        System.out.println("       -d           Debug output");
        System.out.println("       -o outfile   Specify output filename, default: file.bf");
        System.out.println("       -?           Display usage information");
    }

    public static void write(String string) {
        if (debug) {
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '\t') {
                    insert = !insert;
                } else if (string.charAt(n) == '\n') {
                    if (!insert && linepos != 1) {
                        out.println();
                        linepos = 1;
                    } else if (insert && linepos != 12) {
                        out.println();
                        out.print("           ");
                        linepos = 12;
                    }
                } else {
                    if (linepos > 65) {
                        out.println();
                        linepos = 1;
                        if (insert) {
                            out.print("           ");
                            linepos = 12;
                        }
                    }
                    out.print(string.charAt(n));
                    ++linepos;
                }
                ++n;
            }
        } else {
            out.print(string);
        }
    }

    static {
        var = new HashMap();
        label = new HashMap();
        varnext = 0;
        line = 0;
        mp = 0;
        linepos = 1;
        p = "";
        sourceline = "";
        dostack = new Stack();
        forstack = new Stack();
        ifstack = new Stack();
        annex = 1;
        doannex = 1;
        ifannex = 1;
        forannex = 1;
        gosubannex = 1;
    }
}

